;_____________________________________________________________________
; Program : Selectable CW filter. Use terminal on PC to select (W)ide
;           or (N)arrow filter. Set baudrate in bios.asm
; Author  : Danie Brynard ZS6AWK
; Email   : danie.brynard@pixie.co.za
; File    : cw.asm
; Update  : 27/8/95
; Compiler: ASM56000 ver5.3.2
; Target  : DSP56002EVM
; Ref     : Motorola Application Note 'Implementing IIR/FIR Filters
;           with Motorola's DSP56000/DSP56001', p7-30, #APR7/D Rev2
; Notes   : Uses ALEFNUL's leonid.asm monitor & KC7WW's bios.asm
;           Based on ideas from ALEFNUL.
;           Please send remarks on operation or bugs to above email
;           address.
; Status  : works 100%
; History :
;_____________________________________________________________________
	nolist
	include 'leonid'
	list


buflen	equ	600
; flags
thruflg  equ     0      ; FIR filter on/off

	org	p:user_code

	move		    #buffer+2,r7
	move		    #buflen*4-1,m7

	move		    #buffer,r2
	move		    #4-1,n2
	move		    #buflen*4-1,m2

	ctrlcd	1,r2,buflen,MIC,0.0,0.0,LINEO|HEADP,0.0,0.0
	opencd	8,NOHPF

; main loop, use CODEC as sequencer:
loop	waitblk r2,buflen,1

; then filter the left channel
	move		    #buflen*4-1,m0
	move		    #-4,n0
	move		    #coeffs,r4

        jset    #thruflg,x:<flags,_thruon  ; see if thru active
        move                r2,r0
        move                (r2)+
        ; FIR Filter
        clr     a           x:(r0)+n0,x0  y:(r4)+,y0 ;save input, fetch coeff
        rep     #NTAPS-1                             ;repeat next instruction
        mac     x0,y0,a     x:(r0)+n0,x0  y:(r4)+,y0 ;FIR filter now
        macr    x0,y0,a                              ;round result & adj r0
        move                a,y:(r2)+                ; left channel out
        move                a,y:(r2)+                ; right channel out
	move			(r2)+
        jmp     _jmplp

; send data straight through DSP without filtering
_thruon move                r2,r0     ;r0=r2= left channel
        move                (r2)+     ;inc ptr to left channel output
        move                x:(r0),a  ;store x-input sample in a-reg
        move                a,y:(r2)+ ; left channel out +post increment
        move                a,y:(r2)+ ; right channel out+post increment
        move                    (r2)+ ; inc to next x input sample

_jmplp  jsr     <chk_cmd
        jmp     <loop
        ; end of main loop

; Check for control from PC:
chk_cmd lookc   0            ; check if keypressed
        jcs     <_cmdend
        move    #>'w',a
	cmp	x0,a
        jne     <_chkN
        move    #>'W',x0    ; yes, confirm with W
        putc
        bset    #thruflg,x:<flags   ; set wide on
        jmp     _cmdend
_chkN   move    #>'n',a
	cmp	x0,a
        jne     <_cmdend
        move    #>'N',x0    ; yes, confirm with N
        putc
        bclr    #thruflg,x:<flags   ; set wide off
_cmdend rts

; User data areas:
	org	x:$2000
buffer	dsm	buflen*4

        org     x:user_data+6
flags   dc      $01   ;wide filter on by default

	org	y:user_data
        include 'cwcoeff.asm'

	org	y:$2000
	dsm	buflen*4

	end
; end of dsp program
